	function [h, dev, iext] = REMEZ_EX_A(nfcns, grid, des, wt)
	 	
	% 	Function REMEZ_EX_A implements the Remez exchange algorithm for the weigthed 
	%	Chebyshev approximation of a continous function with a sum of cosines.

	 %	Toolbox for DIGITAL FILTERS USING MATLAB 
	 
	 % 	Author: 		Tapio Saramaki, 2018-01-20
	 % 	Modified by: 	LW 2018-02-11
	 % 	Copyright:		by authors - not released for commercial use
	 % 	Version: 		1
	 % 	Known bugs: 
	 % 	Report bugs to:	tapio.saramaki@tut.fi
	 %
	 
	% Inputs
	%     nfcns - number of basis functions 
	%     grid - frequency grid between 0 and 1
	%     des - desired function on frequency grid
	%     wt - weight function on frequency grid
	% Outputs
	%     h - coefficients of the filtercase = 1 filter
	%     dev - the resulting value of the weighted error function
	%     iext - indices of extremal frequencies
	
	%=========================================================================
	% Some initializations
	%=========================================================================
	ngrid = length(grid); 	% number of grid points
	l_ove = 1:ngrid;		 %overall index vector
	temp = (ngrid-1)/nfcns;
	jj = 1:nfcns;
	l_trial = fix([temp*(jj-1)+1 ngrid]);
	nz = nfcns + 1;
	devl = 0;
	niter = 1; 
	itrmax = 250; 
	x_all = cos(pi*grid);
	%=========================================================================
	% Remez loop
	%=========================================================================
	while (niter < itrmax)
		x = cos(pi*grid(l_trial)); 
		%--------------------------------------------------------------------------
		% The following way of calculating the Lagrange interpolation coefficients
		% has been copied from the PM code. The original idea is excellent because
		% the high accuracy is maintained up to the filter order of 2000
		%--------------------------------------------------------------------------
		jet = fix((nfcns - 1)/15) + 1;    
		for mm = 1:nz
			yy = 1;
			for nn=1:jet
				xx = 2*(x(mm) - x(nn:jet:nz));
				yy = yy*prod(xx(xx ~= 0));
			end
			ad(mm) = 1/yy;
		end
		alter = ones(size(ad));
		alter(2:2:nz) = -alter(2:2:nz);
		dnum = ad*des(l_trial)';
		dden = alter*(ad./wt(l_trial))';
		dev = -dnum/dden; 
		if abs(dev) <= abs(devl)
			%#############################################
			% a need to use a more informative message.
			%#############################################
			warning('convergence problems')
			break;
		end
		devl = dev;  
		y = des(l_trial) + dev*alter./wt(l_trial);
		l_left = setdiff(l_ove,l_trial);
		err_num = zeros(size(l_left)); 
		err_den = err_num; 
		for jj = 1:nz 
			aid = ad(jj)./(x_all(l_left) - x(jj)); 
			err_den = err_den + aid; 
			err_num = err_num + y(jj)*aid;
		end
		wei_err(l_left) = (err_num./err_den - des(l_left)).*wt(l_left);
		wei_err(l_trial) = alter*dev;
		l_aid1 = find(diff(sign(diff([0 wei_err 0]))));
		l_aid2 = l_aid1(abs(wei_err(l_aid1)) >= abs(dev));
		[X,ind] = max(sparse(1:length(l_aid2),... 
		cumsum([1,(wei_err(l_aid2(2:end))>=0) ...
		~=(wei_err(l_aid2(1:end-1))>=0)]),...
		abs(wei_err(l_aid2))));
		l_real_init = l_aid2(ind); 
		if rem(length(l_real_init) - nz,2) == 1 
			if abs(wei_err(l_real_init(1))) <= abs(wei_err(l_real_init(end)))
				l_real_init(1) = []; 
			else
				l_real_init(end) = [];
			end
		end
		while length(l_real_init) > nz
			wei_real = abs(wei_err(l_real_init)); 
			wei_comp = max(wei_real(1:end-1),...
	        wei_real(2:end)); 
			if max(abs(wei_err(l_real_init(1))),... 
	            abs(wei_err(l_real_init(end))))<= min(wei_comp)
				l_real_init = l_real_init(2:end-1); 
			else
				[X,ind_omit] = min(wei_comp);
				l_real_init(ind_omit:ind_omit+1) = []; 
			end
		end
		l_real = l_real_init;
		if (l_real == l_trial) 
			break; 
		else
			l_trial = l_real;
			niter = niter + 1; 
		end 
	end 
	iext = l_real; % final indices of the extremal points for the output
	%==========================================================================
	% Generate the impulse response of the filtercase = 1 filter using the IDFT.  
	% It is not very straightforward because the result of the Remez loop is
	% expressed using the Lagrange interpolation formula in barycentric form
	% The generation of this impulse response follows exactly the idea in the 
	% the PMR code.
	%=======================================================================
	cn = 2*nfcns - 1; 
	x_IDFT = 0:2/cn:2*(nfcns-1)/cn;
	x_IDFT = cos(pi*x_IDFT);
	[X,ind1] = intersect(x_IDFT,x); 
	[X,ind2] = intersect(x,x_IDFT);
	ind1 = sort(ind1');
	ind2 = sort(ind2');
	l_ove = 1:nfcns;
	l_left = setdiff(l_ove,ind1);
	num = zeros(size(l_left));
	den = num;
	for jj = 1:nz
	    aid = ad(jj)./(x_IDFT(l_left) - x(jj));
	    den = den + aid;
	    num = num + y(jj)*aid;
	end
	A(l_left) = num./den;
	A(ind1) = y(ind2); 
	for n = 1:nfcns
	    h(n) = (1/cn)*(A(1)+sum(2*A(2:nfcns).*cos(2*pi*(1:nfcns-1)*(n-1)/cn)));
	end
	h = real(h);
	h = [h(nfcns:-1:1) h(2:nfcns)];
